/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.goblintraders.init.ModEntities;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ForgeLootTableProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTableProvider
extends ForgeLootTableProvider {
    private static final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> TABLES = ImmutableList.of((Object)Pair.of(() -> new EntityProvider(), (Object)LootParameterSets.field_216263_d));

    public LootTableProvider(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return TABLES;
    }

    private static class EntityProvider
    extends EntityLootTables {
        private EntityProvider() {
        }

        protected void addTables() {
            this.func_218582_a((EntityType)ModEntities.GOBLIN_TRADER.get(), LootTable.func_216119_b().func_216040_a(new LootPool.Builder().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151034_e).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), LootTable.func_216119_b().func_216040_a(new LootPool.Builder().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151172_bF).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(entityType -> entityType.getRegistryName() != null && "goblintraders".equals(entityType.getRegistryName().func_110624_b())).collect(Collectors.toSet());
        }
    }
}

